<?php

get_header();
$term = get_queried_object();
// dd($term );
$category_id = $term->term_id;
$all_level = get_plugin_category_ancestors($category_id);
//dd($category_id );
$sort_by = null;
if (!empty($_GET['sort_by'])) {
    $sort_by = $_GET['sort_by'];
}
$filters = [];
if ($sort_by == "oldest") {
    $filters[] = "plugin_age_days:desc";
} elseif ($sort_by == "newest") {
    $filters[] = "plugin_age_days:asc";
} elseif ($sort_by == "popular") {
    $filters[] = "rating:desc";
}

$overall_wpscore_plugin = plugin_cpt_frontend_load::get_plugins_with_category_id_filter($category_id, 3, 0, array_reverse(array_merge($filters, ["overall_wpscore:desc"])));

$is_sponsored_plugin = plugin_cpt_frontend_load::get_plugins_with_category_id_filter(
    $category_id,
    3,
    0,
    $filters,
    'is_sponsored',
    2
);
$based_on_active_install = plugin_cpt_frontend_load::get_plugins_with_category_id_filter(
    $category_id,
    3,
    0,
    $filters,
    null,
    null
);
$high_performace_impact = plugin_cpt_frontend_load::get_plugins_with_category_id_filter(
    $category_id,
    3,
    0,
    array_reverse(array_merge($filters, ["performance_impact:desc"])),
    null,
    null
);

?>

<main>
    <section class="border-b border-[#F2F2F2]">
        <div class="container">
            <div class="space-y-1">
                <div class="flex flex-wrap items-center text-[13px] font-normal leading-[120%] text-[#A1A7B1]">
                    <div>
                        <a href="index.html" class="px-1 py-3 inline-block">
                            <img class="w-6 min-w-6 h-6 object-contain object-center"
                                src="<?php echo asset_image_path_generator() . 'category-page/home.svg' ?>"
                                alt="Home-image" />
                        </a>
                    </div>
                    <div class="px-1 space-x-3">
                        <span>/</span>
                        <a href="#" class="py-3 inline-block hover:text-black duration-300">Plugin Category</a>
                    </div>
                    <?php
                    foreach ($all_level as $single_level) {

                    ?>
                        <div class="px-1 space-x-3">
                            <span>/</span>
                            <a href="<?php echo $single_level['link'] ?>"
                                class="py-1 sm:py-3 inline-block hover:text-black duration-300"><?php echo $single_level['name'] ?></a>
                        </div>
                    <?php
                    }
                    ?>
                    <!--  -->
                </div>

                <div class="space-y-3">
                    <h1 class="text-3xl md:text-4xl lg:text-[49px] font-bold leading-[120%]">
                        <?php echo $term->name ?>
                    </h1>
                    <div class="flex flex-col sm:flex-row items-center space-x-6 lg:space-x-[30px]">
                        <label class="relative w-full">
                            <span class="absolute top-1/2 -translate-y-1/2 left-0 w-5 min-w-5 h-5">
                                <img class="w-full object-contain object-center"
                                    src="<?php echo asset_image_path_generator() . 'search.svg' ?>"
                                    alt="search-image" />
                            </span>
                            <button class="absolute top-1/2 -translate-y-1/2 right-0 w-5 min-w-5 h-5">
                                <img class="w-full object-contain object-center"
                                    src="<?php echo asset_image_path_generator() . 'close-circle.svg' ?>"
                                    alt="close-circle-image" />
                            </button>
                            <input type="text"
                                class="noAutofillBg w-full px-8 py-[14.8px] text-base font-normal leading-[160%] border-none placeholder:text-[#A1A7B1]"
                                placeholder="Search plugins" />
                        </label>

                        <div class="w-px self-stretch bg-[#F2F2F2]"></div>

                        <div class="flex items-center space-x-3">
                            <a href="#">
                                <img class="w-5 min-w-5 h-5 object-contain object-center"
                                    src="<?php echo asset_image_path_generator() . 'category-page/filter.svg' ?>"
                                    alt="filter-image" />
                            </a>
                            <div class="space-y-1.5 leading-none">
                                <span class="text-[10px] font-normal leading-[110%] text-[#727C89]">
                                    Sort by:
                                </span>
                                <div class="">
                                    <select
                                        class="p-0 border-0 outline-none appearance-none bg-transparent cursor-pointer focus:outline-none focus:ring-1 focus:ring-gray-300 text-base font-bold leading-[160%] text-[#000000]"
                                        id="plugin_category_page_filter_select">
                                        <option value="relevance" <?php echo $sort_by == "relevance" ? "selected" : null; ?>>Relevance</option>
                                        <option value="popular" <?php echo $sort_by == "popular" ? "selected" : null; ?>>
                                            Most Popular</option>
                                        <option value="newest" <?php echo $sort_by == "newest" ? "selected" : null; ?>>
                                            Newest</option>
                                        <option value="oldest" <?php echo $sort_by == "oldest" ? "selected" : null; ?>>
                                            Oldest</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Higher WPS Score -->
    <section>
        <div class="container">
            <div class="py-8 space-y-3">
                <div class="flex justify-between items-center font-bold">
                    <h4 class="w-[206px] sm:w-auto text-lg lg:text-xl leading-[120%] text-black">
                        <?php echo $overall_wpscore_plugin[0]['overall_wpscore'] ?>+ PMOS Score
                    </h4>
                    <div>
                        <a href=""
                            class="group flex items-center py-[6.3px] px-4 sm:px-6 text-base leading-[160%] text-[#1A2DC9] hover:text-white hover:bg-[#1A2DC9] duration-300 space-x-2.5 border border-[#1B3CD2] rounded-full">
                            <span>View All</span>
                            <svg width="16" height="16" viewBox="0 0 16 16" fill="none"
                                xmlns="http://www.w3.org/2000/svg">
                                <path class="group-hover:fill-white"
                                    d="M10.7814 7.33327L7.20539 3.75726L8.14819 2.81445L13.3337 7.99993L8.14819 13.1853L7.20539 12.2425L10.7814 8.6666H2.66699V7.33327H10.7814Z"
                                    fill="#1A2DC9" />
                            </svg>
                        </a>
                    </div>
                </div>

                <div class="-m-3 lg:-m-4">
                    <div class="flex flex-wrap justify-center items-stretch">
                        <?php
                        foreach ($overall_wpscore_plugin as $plugin) {
                            $single_plugin = $plugin; // rename variable for clarity
                            $template = get_template_directory() . '/frontend/content-single-plugin.php';

                            if (file_exists($template)) {
                                include $template;
                            }
                        }

                        ?>


                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- is Sponsored  -->
    <?php
    if (!empty($is_sponsored_plugin)) {
    ?>
        <section class="bg-[#F8F8F8]">
            <div class="container">
                <div class="py-8 space-y-3">
                    <div>
                        <a href=""
                            class="group w-auto inline-flex items-center py-1 px-2 text-[10px] font-bold leading-[120%] text-[#14243B] hover:text-[#1A2DC9] hover:border-[#1A2DC9] duration-300 space-x-1 border border-[#000000] rounded-full">
                            <svg width="12" height="12" viewBox="0 0 12 12" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path class="group-hover:fill-[#1A2DC9]"
                                    d="M6 11C3.23857 11 1 8.7614 1 6C1 3.23857 3.23857 1 6 1C8.7614 1 11 3.23857 11 6C11 8.7614 8.7614 11 6 11ZM6 10C8.20915 10 10 8.20915 10 6C10 3.79086 8.20915 2 6 2C3.79086 2 2 3.79086 2 6C2 8.20915 3.79086 10 6 10ZM6.5 5.25V7.5H7V8.5H5V7.5H5.5V6.25H5V5.25H6.5ZM6.75 4C6.75 4.41422 6.4142 4.75 6 4.75C5.5858 4.75 5.25 4.41422 5.25 4C5.25 3.58578 5.5858 3.25 6 3.25C6.4142 3.25 6.75 3.58578 6.75 4Z"
                                    fill="black" />
                            </svg>

                            <span>Sponsored</span>
                        </a>
                    </div>

                    <div class="-m-3 lg:-m-4">
                        <div class="flex flex-wrap justify-center items-stretch">
                            <?php
                            foreach ($is_sponsored_plugin as $plugin) {
                                $single_plugin = $plugin; // rename variable for clarity
                                $template = get_template_directory() . '/frontend/content-single-plugin.php';

                                if (file_exists($template)) {
                                    include $template;
                                }
                            }

                            ?>
                        </div>
                    </div>
                </div>
            </div>
        </section>

    <?php
    }
    ?>


    <section>
        <div class="container">
            <div class="py-8 space-y-3">
                <div class="flex justify-between items-center font-bold">
                    <h4 class="w-[206px] sm:w-auto text-lg lg:text-xl leading-[120%] text-black">
                        Over <?php echo format_active_installs($based_on_active_install[2]["active_installs"]) ?>
                        Installations
                    </h4>
                    <div>
                        <a href=""
                            class="group flex items-center py-[6.3px] px-4 sm:px-6 text-base leading-[160%] text-[#1A2DC9] hover:text-white hover:bg-[#1A2DC9] duration-300 space-x-2.5 border border-[#1B3CD2] rounded-full">
                            <span>View All</span>
                            <svg width="16" height="16" viewBox="0 0 16 16" fill="none"
                                xmlns="http://www.w3.org/2000/svg">
                                <path class="group-hover:fill-white"
                                    d="M10.7814 7.33327L7.20539 3.75726L8.14819 2.81445L13.3337 7.99993L8.14819 13.1853L7.20539 12.2425L10.7814 8.6666H2.66699V7.33327H10.7814Z"
                                    fill="#1A2DC9" />
                            </svg>
                        </a>
                    </div>
                </div>

                <div class="-m-3 lg:-m-4">
                    <div class="flex flex-wrap justify-center items-stretch">
                        <?php
                        foreach ($based_on_active_install as $plugin) {
                            $single_plugin = $plugin; // rename variable for clarity
                            $template = get_template_directory() . '/frontend/content-single-plugin.php';

                            if (file_exists($template)) {
                                include $template;
                            }
                        }

                        ?>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section>
        <div class="container">
            <div class="py-8 space-y-3">
                <div class="flex justify-between items-center font-bold">
                    <h4 class="w-[206px] sm:w-auto text-lg lg:text-xl leading-[120%] text-black">
                        High Performance Impact
                    </h4>
                    <div>
                        <a href=""
                            class="group inline-flex items-center py-[6.3px] px-4 sm:px-6 text-base leading-[160%] text-[#1A2DC9] hover:text-white hover:bg-[#1A2DC9] duration-300 space-x-2.5 border border-[#1B3CD2] rounded-full">
                            <span>View All</span>
                            <svg width="16" height="16" viewBox="0 0 16 16" fill="none"
                                xmlns="http://www.w3.org/2000/svg">
                                <path class="group-hover:fill-white"
                                    d="M10.7814 7.33327L7.20539 3.75726L8.14819 2.81445L13.3337 7.99993L8.14819 13.1853L7.20539 12.2425L10.7814 8.6666H2.66699V7.33327H10.7814Z"
                                    fill="#1A2DC9" />
                            </svg>
                        </a>
                    </div>
                </div>

                <div class="-m-3 lg:-m-4">
                    <div class="flex flex-wrap justify-center items-stretch">
                        <?php
                        foreach ($high_performace_impact as $plugin) {
                            $single_plugin = $plugin; // rename variable for clarity
                            $template = get_template_directory() . '/frontend/content-single-plugin.php';

                            if (file_exists($template)) {
                                include $template;
                            }
                        }

                        ?>
                    </div>
                </div>
            </div>
        </div>
    </section>
</main>
<script>
    jQuery(document).ready(function($) {
        // ✅ All your jQuery code here
        $("#plugin_category_page_filter_select").on('change', function() {
            const selectedValue = $(this).val();

            // Get the current page URL
            let url = new URL(window.location.href);

            // Update or add ?sort_by=
            url.searchParams.set('sort_by', selectedValue);

            // Reload page with new parameter
            window.location.href = url.toString();
        });
        console.log('jQuery is ready!');
    });
</script>
<?php get_footer(); ?>